/*
  Settings class for Bombing Run game.
  ini file can have map specific settings in [MapName UTBRSettings] sections.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
*/

class UTBRSettings extends object perobjectconfig config(BombingRun);

var () config string AllowTranslocators;
var () config string AllowHoverboards;
var () config string AllowVehicles; 
var () config string AllowBallCarrierWeapons;
var () config string BallSpeed;
var () config string DisplayMiniMap;    //can disable the minimap on hud which shows objectives
var () config string DisableShootingScore;  //useful for maps where goal is in open and it's too easy to score by shooting
var () config string NecrisTheme;
var () config string GameSpeedMultiplier;
var () config string Mutators;

//we set gravity and jumps to be like ut2k3 by default. BR is a movement oriented game so the
//higher gravity and limited jumps of regular ut3 doesn't do very well.    
var () config string WorldGravityZ;   
var () config string MultiJumpBoost;  
var () config string AllowDodgeJumping;
var () config string MaxMultiJump; 
var () config string StandardUTFeel;

var() config string ShowEnemyTeamOnMiniMap;
var() config string ShowHomeTeamOnMiniMap;
var() config string CarryBallInVehicles;
var() config string Debug;
var() config string BallCarrierHealthRegenerated;

var UTBRSettings Defaults;
var string parseStr;

//return next value from parseStr
function string ParseNext()
{
    local int i;
    local string s;
    
    i = instr(parseStr, ",");
    if ( i >= 0)
    {
        s = mid(parseStr, 0, i);
        parseStr = mid(parseStr, i + 1);
    }
    else
    {
        s = parseStr;
        parseStr = "";
    }
    
    return s;
}

//populate variables with data from Serialize()
function DeSerialize(string serializedData, string sMutators)
{
    parseStr = serializedData;
    ParseValues();
    
    Mutators = sMutators;
}

function ResetToDefaults()
{
    parseStr = "";
    ParseValues();

    Mutators = "";  

    SetDefaults();    
}

//can't replicate an Object so must serialize manually by putting values to string
function string Serialize()
{
  return 
  MaxMultiJump $ "," $
  BallSpeed $ "," $
  DisplayMiniMap $ "," $
  WorldGravityZ $ "," $
  MultiJumpBoost $ "," $
  AllowDodgeJumping $ "," $
  NecrisTheme $ "," $
  DisableShootingScore $ "," $
  StandardUTFeel $ "," $
  GameSpeedMultiplier $ "," $
  AllowTranslocators $ "," $
  AllowHoverboards $ "," $
  AllowVehicles $ "," $
  AllowBallCarrierWeapons $ "," $
  ShowEnemyTeamOnMiniMap $ "," $
  ShowHomeTeamOnMiniMap $ "," $
  CarryBallInVehicles $ "," $
  BallCarrierHealthRegenerated;
}

//set variables from parseStr data
function ParseValues()
{
  MaxMultiJump = ParseNext();
  BallSpeed = ParseNext();
  DisplayMiniMap = ParseNext();
  WorldGravityZ = ParseNext();
  MultiJumpBoost = ParseNext();
  AllowDodgeJumping = ParseNext();
  NecrisTheme = ParseNext();
  DisableShootingScore = ParseNext();  
  StandardUTFeel = ParseNext();
  GameSpeedMultiplier = ParseNext();
  AllowTranslocators = ParseNext();
  AllowHoverboards = ParseNext();
  AllowVehicles = ParseNext();
  AllowBallCarrierWeapons = ParseNext();
  ShowEnemyTeamOnMiniMap = ParseNext();
  ShowHomeTeamOnMiniMap = ParseNext();
  CarryBallInVehicles = ParseNext();
  BallCarrierHealthRegenerated = ParseNext();
}

function SetDefaults()
{   
  if (MaxMultiJump == "") MaxMultiJump = "1";
  if (BallSpeed == "") BallSpeed = "1300";
  if (DisplayMiniMap == "") DisplayMiniMap = "true";
  if (WorldGravityZ == "") WorldGravityZ = "-420";
  if (MultiJumpBoost == "") MultiJumpBoost = "25";
  if (AllowDodgeJumping == "") AllowDodgeJumping = "true";
  if (NecrisTheme == "") NecrisTheme = "false";
  if (DisableShootingScore == "") DisableShootingScore = "false";  
  if (StandardUTFeel == "") StandardUTFeel = "false";
  if (GameSpeedMultiplier == "") GameSpeedMultiplier = "1.0";
  if (AllowTranslocators == "") AllowTranslocators = "false";
  if (AllowHoverboards == "") AllowHoverboards = "false";
  if (AllowVehicles == "") AllowVehicles = "true";                    
  if (AllowBallCarrierWeapons == "") AllowBallCarrierWeapons = "false";
  if (ShowEnemyTeamOnMiniMap == "") ShowEnemyTeamOnMiniMap = "false";
  if (ShowHomeTeamOnMiniMap == "") ShowHomeTeamOnMiniMap = "true";
  if (CarryBallInVehicles == "") CarryBallInVehicles = "true";
  if (BallCarrierHealthRegenerated == "") BallCarrierHealthRegenerated = "5";
}

function MergeSettings(UTBRSettings settings)
{
  if (settings.Mutators != "") Mutators = settings.Mutators;
  if (settings.Debug != "") Debug = settings.Debug;
    
  if (settings.MaxMultiJump != "") MaxMultiJump = settings.MaxMultiJump;
  if (settings.BallSpeed != "") BallSpeed = settings.BallSpeed;
  if (settings.DisplayMiniMap != "") DisplayMiniMap = settings.DisplayMiniMap;
  if (settings.WorldGravityZ != "") WorldGravityZ = settings.WorldGravityZ;
  if (settings.MultiJumpBoost != "") MultiJumpBoost = settings.MultiJumpBoost;
  if (settings.AllowDodgeJumping != "") AllowDodgeJumping = settings.AllowDodgeJumping;
  if (settings.NecrisTheme != "") NecrisTheme = settings.NecrisTheme;
  if (settings.DisableShootingScore != "") DisableShootingScore = settings.DisableShootingScore;  
  if (settings.StandardUTFeel != "") StandardUTFeel = settings.StandardUTFeel;
  if (settings.GameSpeedMultiplier != "") GameSpeedMultiplier = settings.GameSpeedMultiplier;
  if (settings.AllowTranslocators != "") AllowTranslocators = settings.AllowTranslocators;
  if (settings.AllowHoverboards != "") AllowHoverboards = settings.AllowHoverboards;
  if (settings.AllowVehicles != "") AllowVehicles = settings.AllowVehicles;                    
  if (settings.AllowBallCarrierWeapons != "") AllowBallCarrierWeapons = settings.AllowBallCarrierWeapons;
  if (settings.ShowEnemyTeamOnMiniMap != "") ShowEnemyTeamOnMiniMap = settings.ShowEnemyTeamOnMiniMap;
  if (settings.ShowHomeTeamOnMiniMap != "") ShowHomeTeamOnMiniMap = settings.ShowHomeTeamOnMiniMap;  
  if (settings.CarryBallInVehicles != "") CarryBallInVehicles = settings.CarryBallInVehicles;
  if (settings.BallCarrierHealthRegenerated != "") BallCarrierHealthRegenerated = settings.BallCarrierHealthRegenerated;
}
   
defaultproperties
{
    Name="Default__UTBRSettings"
}
